import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class FiguryApp extends JFrame implements MouseListener {
  private CircleDatabase database;
  private Random r;
  public FiguryApp() {
    super("Figury");
    setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    addMouseListener (this);
    database = new CircleDatabase();
    r = new Random();
    setSize(320, 200);
    setVisible(true);
  }
  public void paint (Graphics gDC) {
    gDC.clearRect(0, 0, getSize().width, getSize().height);
    database.drawAll(gDC);
  }
  public void mousePressed (MouseEvent evt) {
    int x = evt.getX();
    int y = evt.getY();
    Color color = new Color (r.nextInt());
    database.addElement (new Circle(x, y, color));
    repaint();
  }
  public static void main(String args[]) {
    SwingUtilities.invokeLater(new Runnable() {
      public void run() {
        new FiguryApp();
      }
    });
  }
  public void mouseExited (MouseEvent evt){}
  public void mouseEntered (MouseEvent evt){}
  public void mouseReleased (MouseEvent evt){}
  public void mouseClicked (MouseEvent evt){}
}
